# coding: UTF-8
##!!!!##################################################################################################
#### Own written code can be placed above this commentblock . Do not change or delete commentblock! ####
########################################################################################################
##** Code created by generator - DO NOT CHANGE! **##

class SpeakerSystemPlayer10706(hsl20_4.BaseModule):

    def __init__(self, homeserver_context):
        hsl20_4.BaseModule.__init__(self, homeserver_context, "SPEAKER_SYSTEM")
        self.FRAMEWORK = self._get_framework()
        self.LOGGER = self._get_logger(hsl20_4.LOGGING_NONE,())
        self.PIN_I_SPEAKERSYSTEM_HOUSEHOLD=1
        self.PIN_I_DEVICE_ID=2
        self.PIN_I_PLAY_PAUSE=3
        self.PIN_O_TRACKINFO=1
        self.FRAMEWORK._run_in_context_thread(self.on_init)

########################################################################################################
#### Own written code can be placed after this commentblock . Do not change or delete commentblock! ####
###################################################################################################!!!##

    def on_init(self):
        self.household_instance=None

    def on_input_value(self, index, value):
        if(index==self.PIN_I_SPEAKERSYSTEM_HOUSEHOLD):
            self.household_instance=self.FRAMEWORK.get_instance_by_id(value) # Get the instance of the SpeakerSystem Household logic module
            if self.household_instance!=None:
                # Register for trackinfo updates via the instance of the SpeakerSystem Household logic module
                if not self.household_instance.register_for_trackinfo_update(self._get_input_value(self.PIN_I_DEVICE_ID), self.on_trackinfo_event):
                    self.show_error_on_debug_page("Wrong Device ID")
        elif(index==self.PIN_I_PLAY_PAUSE): 
            if self.household_instance!=None:
                # Trigger the play or pause command via the instance of the SpeakerSystem Household logic module
                if not self.household_instance.do_play_or_pause(self._get_input_value(self.PIN_I_DEVICE_ID)):
                    self.show_error_on_debug_page("Play cmd")

    """
    Callback that is registered at the SpeakerSystem Household logic module. Will be called when the played track changes.
    """
    def on_trackinfo_event(self, infostring):
        self._set_output_value(self.PIN_O_TRACKINFO, infostring)

    """
    Dummy method
    Stub for writing on the debug page
    """
    def show_error_on_debug_page(self, err_str):
        pass